Attribute VB_Name = "MdlIniFile"
Option Explicit

Declare Function WritePrivateProfileString Lib "KERNEL32.DLL" Alias "WritePrivateProfileStringA" ( _
    ByVal lpAppName As String, _
    ByVal lpKeyName As Any, _
    ByVal lpString As Any, _
    ByVal lpFileName As String) As Long

Declare Function GetPrivateProfileString Lib "KERNEL32.DLL" Alias "GetPrivateProfileStringA" ( _
    ByVal lpAppName As String, _
    ByVal lpKeyName As Any, _
    ByVal lpDefault As String, _
    ByVal lpReturnedString As String, _
    ByVal nSize As Long, _
    ByVal lpFileName As String) As Long

'
Private Const INI_FILE As String = ".\U3800_Ext_SG_VCorrection.ini"

'********************************************************
' Writes SG GPIB Address in U3800_Ext_SG_VCorrection.ini
'********************************************************
Public Sub WriteIniFile_SG_GPIB_Adrs(ByVal SG_GPIB As String)
    Dim ret As Long
    ret = WritePrivateProfileString("GPIB", "SG", SG_GPIB, INI_FILE)
End Sub
'*********************************************************
' Reads SG GPIB Address from U3800_Ext_SG_VCorrection.ini
'*********************************************************
Public Function ReadIniFile_SG_GPIB_Adrs() As String
    Dim strSg As String
    Dim ret As Long
    
    strSg = "   "
    ret = GetPrivateProfileString("GPIB", "SG", "10", strSg, Len(strSg), INI_FILE)
    strSg = Replace(strSg, Chr(0), "")
    ReadIniFile_SG_GPIB_Adrs = strSg
End Function

'*********************************************************
' Writes U38 GPIB Address in U3800_Ext_SG_VCorrection.ini
'*********************************************************
Public Sub WriteIniFile_U38_GPIB_Adrs(ByVal U38_GPIB As String)
    Dim ret As Long
    ret = WritePrivateProfileString("GPIB", "U38", U38_GPIB, INI_FILE)
End Sub
'**********************************************************
' Reads U38 GPIB Address from U3800_Ext_SG_VCorrection.ini
'**********************************************************
Public Function ReadIniFile_U38_GPIB_Adrs() As String
    Dim strU38 As String
    Dim ret As Long
    
    strU38 = "   "
    ret = GetPrivateProfileString("GPIB", "U38", "8", strU38, Len(strU38), INI_FILE)
    strU38 = Replace(strU38, Chr(0), "")
    ReadIniFile_U38_GPIB_Adrs = strU38
End Function

'**********************************************************
' Writes SG TCP/IP Address in U3800_Ext_SG_VCorrection.ini
'**********************************************************
Public Sub WriteIniFile_SG_TCPIP_Adrs(ByVal SG_TCPIP As String)
    Dim ret As Long
    ret = WritePrivateProfileString("TCPIP", "SG_ADRS", SG_TCPIP, INI_FILE)
End Sub
'***********************************************************
' Reads SG TCP/IP Address from U3800_Ext_SG_VCorrection.ini
'***********************************************************
Public Function ReadIniFile_SG_TCPIP_Adrs() As String
    Dim strSg As String
    Dim ret As Long
    
    strSg = "                "
    ret = GetPrivateProfileString("TCPIP", "SG_ADRS", "192.168.0.2", strSg, Len(strSg), INI_FILE)
    strSg = Replace(strSg, Chr(0), "")
    ReadIniFile_SG_TCPIP_Adrs = strSg
End Function

'***********************************************************
' Writes U38 TCP/IP Address in U3800_Ext_SG_VCorrection.ini
'***********************************************************
Public Sub WriteIniFile_U38_TCPIP_Adrs(ByVal U38_TCPIP As String)
    Dim ret As Long
    ret = WritePrivateProfileString("TCPIP", "U38_ADRS", U38_TCPIP, INI_FILE)
End Sub
'************************************************************
' Reads U38 TCP/IP Address from U3800_Ext_SG_VCorrection.ini
'************************************************************
Public Function ReadIniFile_U38_TCPIP_Adrs() As String
    Dim strU38 As String
    Dim ret As Long
    
    strU38 = "                "
    ret = GetPrivateProfileString("TCPIP", "U38_ADRS", "192.168.0.1", strU38, Len(strU38), INI_FILE)
    strU38 = Replace(strU38, Chr(0), "")
    ReadIniFile_U38_TCPIP_Adrs = strU38
End Function

'**************************************************************
' Writes SG TCP/IP Port Number in U3800_Ext_SG_VCorrection.ini
'**************************************************************
Public Sub WriteIniFile_SG_PortNo(ByVal SG_TCPIP As String)
    Dim ret As Long
    ret = WritePrivateProfileString("TCPIP", "SG_PORT", SG_TCPIP, INI_FILE)
End Sub
'***************************************************************
' Reads SG TCP/IP Port Number from U3800_Ext_SG_VCorrection.ini
'***************************************************************
Public Function ReadIniFile_SG_PortNo() As String
    Dim strSg As String
    Dim ret As Long
    
    strSg = "                "
    ret = GetPrivateProfileString("TCPIP", "SG_PORT", "5025", strSg, Len(strSg), INI_FILE)
    strSg = Replace(strSg, Chr(0), "")
    ReadIniFile_SG_PortNo = strSg
End Function

'***************************************************************
' Writes U38 TCP/IP Port Number in U3800_Ext_SG_VCorrection.ini
'***************************************************************
Public Sub WriteIniFile_U38_PortNo(ByVal U38_TCPIP As String)
    Dim ret As Long
    ret = WritePrivateProfileString("TCPIP", "U38_PORT", U38_TCPIP, INI_FILE)
End Sub
'****************************************************************
' Reads U38 TCP/IP Port Number from U3800_Ext_SG_VCorrection.ini
'****************************************************************
Public Function ReadIniFile_U38_PortNo() As String
    Dim strU38 As String
    Dim ret As Long
    
    strU38 = "                "
    ret = GetPrivateProfileString("TCPIP", "U38_PORT", "5025", strU38, Len(strU38), INI_FILE)
    strU38 = Replace(strU38, Chr(0), "")
    ReadIniFile_U38_PortNo = strU38
End Function

'***************************************************************
' Writes Vector Correction Type in U3800_Ext_SG_VCorrection.ini
'***************************************************************
Public Sub WriteIniFile_U38_VCorr_Type(ByVal VCorrType As String)
    Dim ret As Long
    ret = WritePrivateProfileString("VCorr", "Type", VCorrType, INI_FILE)
End Sub
'****************************************************************
' Reads Vector Correction Type from U3800_Ext_SG_VCorrection.ini
'****************************************************************
Public Function ReadIniFile_U38_VCorr_Type() As String
    Dim strType As String
    Dim ret As Long
    
    strType = "               "
    ret = GetPrivateProfileString("VCorr", "Type", "Specific Span", strType, Len(strType), INI_FILE)
    strType = Replace(strType, Chr(0), "")
    ReadIniFile_U38_VCorr_Type = strType
End Function

'********************************************************
' Writes SG Output Level in U3800_Ext_SG_VCorrection.ini
'********************************************************
Public Sub WriteIniFile_SG_OUT_LVL(ByVal SG_OUT_L As String)
    Dim ret As Long
    ret = WritePrivateProfileString("SG_OUTPUT", "LEVEL", SG_OUT_L, INI_FILE)
End Sub
'*********************************************************
' Reads SG Output Level from U3800_Ext_SG_VCorrection.ini
'*********************************************************
Public Function ReadIniFile_SG_OUT_LVL() As String
    Dim strLevel As String
    Dim ret As Long
    
    strLevel = "    "
    ret = GetPrivateProfileString("SG_OUTPUT", "LEVEL", "-20", strLevel, Len(strLevel), INI_FILE)
    strLevel = Replace(strLevel, Chr(0), "")
    ReadIniFile_SG_OUT_LVL = strLevel
End Function

'**********************************************************************
' Writes SG Output ON/OFF GPIB Command in U3800_Ext_SG_VCorrection.ini
'**********************************************************************
Public Sub WriteIniFile_SG_OUT_STS_Cmd(ByVal SG_OUTPUT_CMD As String)
    Dim ret As Long
    ret = WritePrivateProfileString("SG_OUTPUT", "OUTPUT_CMD", SG_OUTPUT_CMD, INI_FILE)
End Sub
'************************************************************************
' Reads SG Output ON/OFF  GPIB Command from U3800_Ext_SG_VCorrection.ini
'************************************************************************
Public Function ReadIniFile_SG_OUT_STS_Cmd() As String
    Dim strOtCmd As String
    Dim ret As Long
    
    strOtCmd = "                                 "
    ret = GetPrivateProfileString("SG_OUTPUT", "OUTPUT_CMD", "OUTP", strOtCmd, Len(strOtCmd), INI_FILE)
    strOtCmd = Replace(strOtCmd, Chr(0), "")
    ReadIniFile_SG_OUT_STS_Cmd = strOtCmd
End Function

'*******************************************************************
' Writes SG Output ON GPIB Command in U3800_Ext_SG_VCorrection.ini
'*******************************************************************
Public Sub WriteIniFile_SG_OUT_ON_Para(ByVal SG_OUT_OFF_CMD As String)
    Dim ret As Long
    ret = WritePrivateProfileString("SG_OUTPUT", "OUTPUT__ON", SG_OUT_OFF_CMD, INI_FILE)
End Sub
'********************************************************************
' Reads SG Output ON GPIB Command from U3800_Ext_SG_VCorrection.ini
'********************************************************************
Public Function ReadIniFile_SG_OUT_ON_Para() As String
    Dim strOtOnPara As String
    Dim ret As Long
    
    strOtOnPara = "    "
    ret = GetPrivateProfileString("SG_OUTPUT", "OUTPUT__ON", "ON", strOtOnPara, Len(strOtOnPara), INI_FILE)
    strOtOnPara = Replace(strOtOnPara, Chr(0), "")
    ReadIniFile_SG_OUT_ON_Para = strOtOnPara
End Function

'*******************************************************************
' Writes SG Output OFF GPIB Command in U3800_Ext_SG_VCorrection.ini
'*******************************************************************
Public Sub WriteIniFile_SG_OUT_OFF_Para(ByVal SG_OUT_OFF_CMD As String)
    Dim ret As Long
    ret = WritePrivateProfileString("SG_OUTPUT", "OUTPUT_OFF", SG_OUT_OFF_CMD, INI_FILE)
End Sub
'********************************************************************
' Reads SG Output OFF GPIB Command from U3800_Ext_SG_VCorrection.ini
'********************************************************************
Public Function ReadIniFile_SG_OUT_OFF_Para() As String
    Dim strOtOffPara As String
    Dim ret As Long
    
    strOtOffPara = "    "
    ret = GetPrivateProfileString("SG_OUTPUT", "OUTPUT_OFF", "OFF", strOtOffPara, Len(strOtOffPara), INI_FILE)
    strOtOffPara = Replace(strOtOffPara, Chr(0), "")
    ReadIniFile_SG_OUT_OFF_Para = strOtOffPara
End Function

'*********************************************************************
' Writes SG Output Level GPIB Command in U3800_Ext_SG_VCorrection.ini
'*********************************************************************
Public Sub WriteIniFile_SG_OUT_LVL_Cmd(ByVal SG_OUT_LVL_CMD As String)
    Dim ret As Long
    ret = WritePrivateProfileString("SG_OUTPUT", "LEVEL_CMD", SG_OUT_LVL_CMD, INI_FILE)
End Sub
'**********************************************************************
' Reads SG Output Level GPIB Command from U3800_Ext_SG_VCorrection.ini
'**********************************************************************
Public Function ReadIniFile_SG_OUT_LVL_Cmd() As String
    Dim strOtLvCmd As String
    Dim ret As Long
    
    strOtLvCmd = "                                 "
    ret = GetPrivateProfileString("SG_OUTPUT", "LEVEL_CMD", "SOUR:POW", strOtLvCmd, Len(strOtLvCmd), INI_FILE)
    strOtLvCmd = Replace(strOtLvCmd, Chr(0), "")
    ReadIniFile_SG_OUT_LVL_Cmd = strOtLvCmd
End Function

'*********************************************************************
' Writes SG Output Level GPIB Unit in U3800_Ext_SG_VCorrection.ini
'*********************************************************************
Public Sub WriteIniFile_SG_OUT_LVL_Unit(ByVal SG_OUT_LVL_CMD As String)
    Dim ret As Long
    ret = WritePrivateProfileString("SG_OUTPUT", "LEVEL_UNIT", SG_OUT_LVL_CMD, INI_FILE)
End Sub
'*******************************************************************
' Reads SG Output Level GPIB Unit from U3800_Ext_SG_VCorrection.ini
'*******************************************************************
Public Function ReadIniFile_SG_OUT_LVL_Unit() As String
    Dim strOtLvUnit As String
    Dim ret As Long
    
    strOtLvUnit = "     "
    ret = GetPrivateProfileString("SG_OUTPUT", "LEVEL_UNIT", "DBM", strOtLvUnit, Len(strOtLvUnit), INI_FILE)
    strOtLvUnit = Replace(strOtLvUnit, Chr(0), "")
    ReadIniFile_SG_OUT_LVL_Unit = strOtLvUnit
End Function

'*********************************************************************
' Writes SG Frequency GPIB Command in U3800_Ext_SG_VCorrection.ini
'*********************************************************************
Public Sub WriteIniFile_SG_Freq_Cmd(ByVal SG_Freq_Cmd As String)
    Dim ret As Long
    ret = WritePrivateProfileString("SG_OUTPUT", "FREQ_CMD", SG_Freq_Cmd, INI_FILE)
End Sub
'**********************************************************************
' Reads SG Frequency GPIB Command from U3800_Ext_SG_VCorrection.ini
'**********************************************************************
Public Function ReadIniFile_SG_Freq_Cmd() As String
    Dim strFrqCmd As String
    Dim ret As Long
    
    strFrqCmd = "                                 "
    ret = GetPrivateProfileString("SG_OUTPUT", "FREQ_CMD", "SOUR:FREQ", strFrqCmd, Len(strFrqCmd), INI_FILE)
    strFrqCmd = Replace(strFrqCmd, Chr(0), "")
    ReadIniFile_SG_Freq_Cmd = strFrqCmd
End Function

'*********************************************************************
' Writes SG Frequency GPIB Unit in U3800_Ext_SG_VCorrection.ini
'*********************************************************************
Public Sub WriteIniFile_SG_Freq_Unit(ByVal SG_OUT_LVL_CMD As String)
    Dim ret As Long
    ret = WritePrivateProfileString("SG_OUTPUT", "FREQ_UNIT", SG_OUT_LVL_CMD, INI_FILE)
End Sub
'*******************************************************************
' Reads SG Frequency GPIB Unit from U3800_Ext_SG_VCorrection.ini
'*******************************************************************
Public Function ReadIniFile_SG_Freq_Unit() As String
    Dim strFrqUnit As String
    Dim ret As Long
    
    strFrqUnit = "     "
    ret = GetPrivateProfileString("SG_OUTPUT", "FREQ_UNIT", "HZ", strFrqUnit, Len(strFrqUnit), INI_FILE)
    strFrqUnit = Replace(strFrqUnit, Chr(0), "")
    ReadIniFile_SG_Freq_Unit = strFrqUnit
End Function

